//
//  RMLiveViewCropHandlesView.h
//  Analog
//
//  Created by Keith Duncan on 23/05/2011.
//  Copyright 2011 Realmac Software. All rights reserved.
//

#import <Cocoa/Cocoa.h>

@class RMCropHandlesView;

@protocol RMCropHandlesViewDelegate <NSObject>

 @optional

- (void)cropHandlesViewDidBeginEditing:(RMCropHandlesView *)cropHandlesView;
- (void)cropHandlesViewDidEndEditing:(RMCropHandlesView *)cropHandlesView;

/*!
	\brief
	Sent when the model values change
 */
- (void)cropHandlesView:(RMCropHandlesView *)cropHandlesView didUpdateImageRect:(CGRect)imageRect cropRect:(CGRect)cropRect;

/*!
	\brief
	Sent when the handles are dragged or the on screen representation changes due to window resizing and the like
 */
- (void)cropHandlesView:(RMCropHandlesView *)cropHandlesView didUpdateCropHandlesRect:(CGRect)cropHandlesRect;

@end

/*!
	\brief
	Coordinate system region selection.
 */
@interface RMCropHandlesView : NSView {
 @private
	CGFloat _XCoordinates[2];
	CGFloat _YCoordinates[2];
}

/*!
	\brief
	Should be used for minimum interactable region calculations
 */
+ (CGSize)cropHandleSize;

/*!
	\brief
	
 */
@property (assign, nonatomic) IBOutlet id <RMCropHandlesViewDelegate> delegate;

/*!
	\brief
	
 */
@property (assign, nonatomic) NSEdgeInsets edgeInsets;

/*!
	\brief
	Also configures how the view should function based on whether the parameters are CGRectNull
	
	\param imageRect
	If non-CGRectNull this establishes the _pixel_ size of the image coordinate system being cropped
	This region will be drawn in the centre of the view and may be scaled to fit
	If CGRectNull this determines that an abstract crop rect is being selected, not rooted in an image.
	
	\param cropRect
	If non-CGRectNull this is assumed to be the _pixel_ region relative to the imageRect which should be shown selected
	If CGRectNull
	- and imageRect is CGRectNull, no region is shown selected
	- and imageRect is non-CGRectNull, the whole imageRect is selected
	
	\param applyImmediately
	If YES, the new image and crop rects will be applied immediately rather than waiting for the next layout.
 */
- (void)setImageRect:(CGRect)imageRect cropRect:(CGRect)cropRect applyImmediately:(BOOL)applyImmediately;

/*!
	\brief
	Calls setImageRect:cropRect:applyImmediately: with applyImmediately set to NO.
 */
- (void)setImageRect:(CGRect)imageRect cropRect:(CGRect)cropRect;

/*!
	\brief
	Ratio to be enforced when selecting a region
 */
- (void)setCropRectRatio:(CGSize)cropRectRatio;

/*!
	\brief
	In the coordinate system of the receiver, can be used to get the handles position without calculating it
 */
@property (readonly) CGRect cropHandlesRect;

/*!
	\brief
	Determines whether the crop is editable
	If set to NO, the view will not receive mouse and key events
	default = YES
 */
@property (assign, getter=isEditable, nonatomic) BOOL editable;

/*!
	\brief
	if YES, the grid lines will be displayed in the crop area
	default = YES
 */
@property (assign, nonatomic) BOOL showsGrid;

/*!
	\brief
	if YES, the crop handle controls will be displayed
	default = YES
 */
@property (assign, nonatomic) BOOL showsHandles;

/*!
	\brief
	if YES, the background outside of the crop area will be dimmed
	default = YES
 */
@property (assign, nonatomic) BOOL dimsBackground;

@end
